#include <Arduino.h>
#include <BLEDevice.h>
#include <BLEUtils.h>
#include <BLEScan.h>
#include <BLEAdvertisedDevice.h>

BLEScan* pBLEScan;
BLEClient* pClient = nullptr; // Global variable to hold the BLEClient object
int speakerpin=15; // speaker is connected to pin 15
class MyAdvertisedDeviceCallbacks : public BLEAdvertisedDeviceCallbacks
{
void onResult(BLEAdvertisedDevice advertisedDevice)
{
Serial.print("Found BLE Device: ");
Serial.println(advertisedDevice.getName().c_str());
Serial.print("MAC Address: ");
String s=advertisedDevice.getAddress().toString().c_str();
Serial.println(s);
if (s=="XX:XX:XX:XX:XX:XX" || s=="XX:XX:XX:XX:XX:XX")//desired MAC address
{
digitalWrite(speakerpin, HIGH);
delay(5000);
digitalWrite(speakerpin, LOW);
delay(1800000); // buffer time of half hour
delay(1800000); // additional buffer time of half hour
}
}
};
void setup()
{
Serial.begin(115200);
Serial.println("Scanning for BLE devices...");
pinMode(speakerpin, OUTPUT);
BLEDevice::init("");
pBLEScan = BLEDevice::getScan();
pBLEScan->setAdvertisedDeviceCallbacks(new MyAdvertisedDeviceCallbacks());
pBLEScan->setActiveScan(true);
pBLEScan->start(10); // Scan for 10 seconds
}
void loop()
{
BLEScanResults foundDevices = pBLEScan->start(5, false);// scans for BLE devices
pBLEScan->clearResults(); // delete results fromBLEScan buffer to release memory
delay(2000);
}