#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>
#include <U8g2lib.h>
#include <WiFiClientSecure.h>
#include <ArduinoJson.h>
#include <ChatGPT.hpp>

// WiFi credentials
const char* ssid = "JioFiber-4G"; // Your WiFi SSID
const char* password = "1234567890"; // Your WiFi Password

// ChatGPT API key
const char* api_key = "sk-proj-8iBEevh9eVtyKMBEchBhT3BlbkFJsUxCQ6gd9v3nC7hewoPJ"; // Your ChatGPT API key

// Web server and WebSerial
AsyncWebServer server(80);

// OLED display using U8g2 library
U8G2_SSD1306_128X64_ALT0_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE); // Constructor for SSD1306 128x64 OLED display

// ChatGPT client
WiFiClientSecure client;
ChatGPT<WiFiClientSecure> chat_gpt(&client, "v1", api_key);

/* Message callback of WebSerial */
void recvMsg(uint8_t *data, size_t len) {
  WebSerial.println("Received Data...");
  String question = "";
  for (size_t i = 0; i < len; i++) {
    question += char(data[i]);
  }
  WebSerial.println("Question: " + question);

  // Send question to ChatGPT
  String response;
  if (sendToChatGPT(question, response)) {
    // Display response on OLED
    u8g2.clearBuffer();
    u8g2.setCursor(0, 12);
    u8g2.print("Response:");
    printWrappedText(response);

    // Send response via WebSerial
    WebSerial.println("ChatGPT Response: " + response);
  } else {
    WebSerial.println("Error getting response from ChatGPT");
  }
}

void setup() {
  Serial.begin(115200);

  // Initialize OLED
  u8g2.begin();
  u8g2.setFont(u8g2_font_ncenB08_tr);
  u8g2.clearBuffer();
  u8g2.setCursor(0, 12);
  u8g2.print("Connecting to WiFi...");
  u8g2.sendBuffer();

  // Initialize WiFi
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);

  // Display WiFi connection status
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    u8g2.clearBuffer();
    u8g2.setCursor(0, 12);
    u8g2.print("Connecting to WiFi...");
    u8g2.sendBuffer();
  }

  // Display IP address once connected
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());
  u8g2.clearBuffer();
  u8g2.setCursor(0, 12);
  u8g2.print("Connected!");
  u8g2.setCursor(0, 24);
  u8g2.print("IP Address:");
  u8g2.setCursor(0, 36);
  u8g2.print(WiFi.localIP().toString());
  u8g2.sendBuffer();

  // Start WebSerial
  WebSerial.begin(&server);
  WebSerial.msgCallback(recvMsg);
  server.begin();
}

void loop() {
  delay(2000);

  WebSerial.print(F("IP address: "));
  WebSerial.println(WiFi.localIP());
  WebSerial.printf("Millis=%lu\n", millis());
  WebSerial.printf("Free heap=[%u]\n", ESP.getFreeHeap());
}

// Function to send question to ChatGPT
bool sendToChatGPT(String question, String &response) {
  u8g2.clearBuffer();
  u8g2.setCursor(0, 12);
  u8g2.print("Sending...");
  u8g2.sendBuffer();

  if (chat_gpt.simple_message("gpt-3.5-turbo", "user", question, response)) {
    return true;
  } else {
    response = "Error communicating with ChatGPT";
    return false;
  }
}

// Function to print wrapped text on OLED display
void printWrappedText(String text) {
  int16_t cursor_x = 0;
  int16_t cursor_y = 24; // Starting Y position
  uint16_t text_width = u8g2.getDisplayWidth();
  uint16_t text_height = u8g2.getDisplayHeight();

  for (size_t i = 0; i < text.length(); i++) {
    char c = text.charAt(i);
    if (c == '\n') {
      cursor_y += 10;
      cursor_x = 0;
    } else {
      uint8_t w = u8g2.getStrWidth(&c);
      if (cursor_x + w > text_width) {
        cursor_y += 10;
        cursor_x = 0;
      }
      if (cursor_y > text_height - 10) break; // Stop if text exceeds display height
      u8g2.setCursor(cursor_x, cursor_y);
      u8g2.print(c);
      cursor_x += w;
    }
  }
  u8g2.sendBuffer();
}
