# ----------------------------------------------------------------------------
#   An auxiliary function to show messages:
# ----------------------------------------------------------------------------
MACRO(SHOW_CONFIG_LINE MSG_TEXT VALUE_BOOL)
	IF(${VALUE_BOOL})
		SET(VAL_TEXT "Yes")
	ELSE(${VALUE_BOOL})
		SET(VAL_TEXT " No")
	ENDIF(${VALUE_BOOL})
	MESSAGE(STATUS " ${MSG_TEXT} : ${VAL_TEXT} ${ARGV2}")
ENDMACRO(SHOW_CONFIG_LINE)

MACRO(SHOW_CONFIG_LINE_SYSTEM MSG_TEXT VALUE_BOOL)
	IF(${VALUE_BOOL})
		IF(${VALUE_BOOL}_SYSTEM)
			SET(VAL_TEXT "Yes (System)")
		ELSE(${VALUE_BOOL}_SYSTEM)
			SET(VAL_TEXT "Yes (Built-in)")
		ENDIF(${VALUE_BOOL}_SYSTEM)
	ELSE(${VALUE_BOOL})
		SET(VAL_TEXT " No")
	ENDIF(${VALUE_BOOL})
	MESSAGE(STATUS " ${MSG_TEXT} : ${VAL_TEXT} ${ARGV2}")
ENDMACRO(SHOW_CONFIG_LINE_SYSTEM)

# ----------------------------------------------------------------------------
#   Summary:
# ----------------------------------------------------------------------------
MESSAGE(STATUS "")
IF(CMAKE_COMPILER_IS_GNUCXX)
	SET(MRPT_GCC_VERSION_STR "(GCC version: ${CMAKE_MRPT_GCC_VERSION})")
ENDIF(CMAKE_COMPILER_IS_GNUCXX)

MESSAGE(STATUS "+===========================================================================+")
MESSAGE(STATUS "|         Resulting configuration for ${CMAKE_MRPT_COMPLETE_NAME}                            |")
MESSAGE(STATUS "+===========================================================================+")
MESSAGE(STATUS " _________________________ PLATFORM _____________________________")
MESSAGE(STATUS " Host                        : "             ${CMAKE_HOST_SYSTEM_NAME} ${CMAKE_HOST_SYSTEM_VERSION} ${CMAKE_HOST_SYSTEM_PROCESSOR})
if(CMAKE_CROSSCOMPILING)
MESSAGE(STATUS " Target                      : "         ${CMAKE_SYSTEM_NAME} ${CMAKE_SYSTEM_VERSION} ${CMAKE_SYSTEM_PROCESSOR})
endif(CMAKE_CROSSCOMPILING)
SHOW_CONFIG_LINE("Is the system big endian?  " CMAKE_MRPT_IS_BIG_ENDIAN)
MESSAGE(STATUS " Word size (32/64 bit)       : ${CMAKE_MRPT_WORD_SIZE}")
MESSAGE(STATUS " CMake version               : " ${CMAKE_VERSION})
MESSAGE(STATUS " CMake generator             : "  ${CMAKE_GENERATOR})
MESSAGE(STATUS " CMake build tool            : " ${CMAKE_BUILD_TOOL})
MESSAGE(STATUS " Compiler                    : " ${CMAKE_CXX_COMPILER_ID})
if(MSVC)
	MESSAGE(STATUS " MSVC                        : " ${MSVC_VERSION})
endif(MSVC)
if(CMAKE_GENERATOR MATCHES Xcode)
	MESSAGE(STATUS " Xcode                       : " ${XCODE_VERSION})
endif(CMAKE_GENERATOR MATCHES Xcode)
if(NOT CMAKE_GENERATOR MATCHES "Xcode|Visual Studio")
	MESSAGE(STATUS " Configuration               : "  ${CMAKE_BUILD_TYPE})
endif(NOT CMAKE_GENERATOR MATCHES "Xcode|Visual Studio")

IF("${CMAKE_BUILD_TYPE}" STREQUAL "Release")
   MESSAGE( STATUS "C++ flags (Release):     ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELEASE}")
ELSEIF("${CMAKE_BUILD_TYPE}" STREQUAL "Debug")
   MESSAGE( STATUS "C++ flags (Debug):       ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_DEBUG}")
ENDIF()


MESSAGE(STATUS "")
MESSAGE(STATUS " __________________________ OPTIONS _____________________________")
SHOW_CONFIG_LINE("Build YDLidar-SDK as a shared library?　　" BUILD_SHARED_LIBS)
SHOW_CONFIG_LINE("Build Examples?　　　　　　　　　　　　　　" BUILD_EXAMPLES)
SHOW_CONFIG_LINE("Build C Sharp API?　　　　　　　　　　　　" BUILD_CSHARP)
SHOW_CONFIG_LINE("Build TEST?  			　　　" BUILD_TEST)
MESSAGE(STATUS "")

MESSAGE(STATUS " _________________________ INSTALL _____________________")
MESSAGE(STATUS " Install prefix                    : ${CMAKE_INSTALL_PREFIX}")
MESSAGE(STATUS "")

IF($ENV{VERBOSE})
	MESSAGE(STATUS " _________________________ COMPILER OPTIONS _____________________")
	message(STATUS "Compiler:                  ${CMAKE_CXX_COMPILER} ${MRPT_GCC_VERSION_STR} ")
	message(STATUS "  C++ flags (Release):       ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELEASE}")
	message(STATUS "  C++ flags (Debug):         ${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGS_DEBUG}")
	message(STATUS "  Executable link flags (Release):    ${CMAKE_EXE_LINKER_FLAGS} ${CMAKE_EXE_LINKER_FLAGS_RELEASE}")
	message(STATUS "  Executable link flags (Debug):      ${CMAKE_EXE_LINKER_FLAGS} ${CMAKE_EXE_LINKER_FLAGS_DEBUG}")
	message(STATUS "  Lib link flags (Release):    ${CMAKE_SHARED_LINKER_FLAGS} ${CMAKE_SHARED_LINKER_FLAGS_RELEASE}")
	message(STATUS "  Lib link flags (Debug):      ${CMAKE_SHARED_LINKER_FLAGS} ${CMAKE_SHARED_LINKER_FLAGS_DEBUG}")
	MESSAGE(STATUS "")
ENDIF($ENV{VERBOSE})

MESSAGE(STATUS " _______________________ WRAPPERS/BINDINGS ______________________")
SHOW_CONFIG_LINE("Python bindings (pyydlidar)  " SWIG_FOUND)
SHOW_CONFIG_LINE(" - dep: Swig found?      " SWIG_FOUND "[Version: ${SWIG_VERSION}]")
SHOW_CONFIG_LINE(" - dep: PythonLibs found? " PYTHONLIBS_FOUND "[Version: ${PYTHON_VERSION_STRING}]")

MESSAGE(STATUS "")
